<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use EshopCatalog\AdminModule\Components\Manufacturers\IManufacturerFormFactory;
use EshopCatalog\AdminModule\Components\Manufacturers\IManufacturersGridFactory;
use EshopCatalog\AdminModule\Components\Suppliers\ISupplierFormFactory;
use EshopCatalog\AdminModule\Components\Suppliers\ISuppliersGridFactory;
use EshopCatalog\Model\Entities\Manufacturer;
use EshopCatalog\AdminModule\Model\Manufacturers;
use Core\Components\Flashes\Flashes;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\Model\Entities\Supplier;
use EshopCatalog\AdminModule\Model\Suppliers;
use Nette\Http\IResponse;
use Nette\Utils\Html;

/**
 * Class ManufacturersSuppliersPresenter
 * @package EshopCatalog\AdminModule\Presenters
 */
class ManufacturersSuppliersPresenter extends BasePresenter
{

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.manufacturersSuppliers'));
		$this->setHeader('eshopCatalog.title.manufacturersSuppliers', 'fa fa-list');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.addManufacturer',
				'link'  => 'ManufacturersSuppliers:addManufacturer',
				'ico'   => 'plus',
			], [
				'title' => 'eshopCatalog.menu.addSupplier',
				'link'  => 'ManufacturersSuppliers:addSupplier',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddManufacturer()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.newManufacturer'));
		$this->setHeader('eshopCatalog.title.newManufacturer', 'fa fa-list-alt');
	}

	public function actionAddSupplier()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.newSupplier'));
		$this->setHeader('eshopCatalog.title.newSupplier', 'fa fa-list-alt');
	}

	public function actionEditManufacturer($id)
	{
		$manufacturer = $this->em->getRepository(Manufacturer::class)->find($id);

		if (!$manufacturer)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('eshopCatalog.title.editManufacturer'));
		$this->setHeader('eshopCatalog.title.editManufacturer', 'fa fa-list-alt');
	}

	public function actionEditSupplier($id)
	{
		$supplier = $this->em->getRepository(Supplier::class)->find($id);

		if (!$supplier)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('eshopCatalog.title.editSupplier'));
		$this->setHeader('eshopCatalog.title.editSupplier', 'fa fa-list-alt');
	}

	public function actionClose($id)
	{
		$this->redirect('Default:');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentManufacturerForm(IManufacturerFormFactory $manufacturer)
	{
		$control = $manufacturer->create();
		if ($this->getParameter('id'))
			$control->setManufacturer($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('ManufacturersSuppliers:editManufacturer', $form->getCustomData('manufacturerId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('ManufacturersSuppliers:default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('ManufacturersSuppliers:default');
		};

		return $control;
	}

	protected function createComponentManufacturersGrid(IManufacturersGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentSupplierForm(ISupplierFormFactory $suppliers)
	{
		$control = $suppliers->create();
		if ($this->getParameter('id'))
			$control->setSupplier($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('ManufacturersSuppliers:editSupplier', $form->getCustomData('supplierId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('ManufacturersSuppliers:default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('ManufacturersSuppliers:default');
		};

		return $control;
	}

	protected function createComponentSuppliersGrid(ISuppliersGridFactory $factory)
	{
		return $factory->create();
	}
}

