<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Event\RouteInEvent;
use Navigations\Model\Event\RouteOutEvent;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Caching\Cache;
use Nette\Utils\ArrayHash;
use Pages\FrontModule\Model\TemplatePages;

class Search extends BaseNavigation implements INavigationItem
{
	protected $title     = 'search';
	protected $presenter = 'EshopCatalog:Front:Default';
	protected $action    = 'search';

	const CACHE_SEARCH = 'eshopCatalogSearch';

	/** @var TemplatePages */
	protected $templatePagesService;

	public function __construct(TemplatePages $templatePages)
	{
		$this->templatePagesService = $templatePages;
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		$templates = [];
		foreach ($this->templatePagesService->getEr()->findBy(['isPublished' => '1'], ['title' => 'ASC']) as $t)
			$templates[$t->getId()] = $t->title;

		$container->addSelect('templateResult', 'eshopCatalog.navigationBuilder.templateResult', $templates);

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	public function updateCacheDep(array &$cache, $urlParams)
	{
		$cache[Cache::TAGS][] = self::CACHE_SEARCH . '/' . $urlParams['q'];

		parent::updateCacheDep($cache, $urlParams);
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return $this->presenter == $presenter && $this->action == $action;
	}

	/**
	 * @param Navigation $navigation
	 * @param array      $urlParams
	 *
	 * @return array|mixed
	 */
	public function routerIn($navigation, $urlParams = [])
	{
		$return = [
			'presenter' => $this->presenter,
			'action'    => $this->action,
		];

		$parts = explode('/', $urlParams['path']);

		if (isset($parts[1]))
			$return['q'] = $parts[1];
		else if (isset($urlParams['q']))
			$return['q'] = $urlParams['q'];

		$this->eventDispatcher->dispatch(BaseNavigation::class . '::routeIn', new RouteInEvent($navigation, $urlParams, $return));

		return $return;
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		$q = $urlParams['q'] ?? null;
		unset($urlParams['q']);

		if (isset($urlParams['do']) && strpos($urlParams['do'], 'searchForm') !== false)
			unset($urlParams['do']);

		$url = ($navigation->isHomepage ? '' : '/' . $navigation->alias) . ($q ? '/' . $q : '');

		$this->eventDispatcher->dispatch(BaseNavigation::class . '::routeOut', new RouteOutEvent($navigation, $urlParams, $url));

		return $url;
	}
}
