<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Form;
use Nette\Http\IResponse;
use Nette\Http\Request;
use Nette\Utils\ArrayHash;
use EshopCatalog\Model\Entities\Product;
use EshopCatalog\Model\Entities\ProductTexts;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\AdminModule\Model\Categories;
use EshopCatalog\AdminModule\Model\CategoryProducts;
use EshopCatalog\Model\Entities\CategoryProduct;
use EshopCatalog\Model\Entities\Category;

class ProductsCategoryForm extends BaseControl
{
	/** @var array */
	public $products;

	/** @var string */
	private $ids;

	/** @var Products */
	protected $productServices;

	/** @var \EshopCatalog\AdminModule\Model\CategoryProducts */
	protected $categoryProductServices;

	/** @var \EshopCatalog\AdminModule\Model\Categories */
	protected $categoryServices;

	/** @var CategoryContainer */
	protected $categoryContainerService;

	public function __construct(Products $products, Categories $categories, CategoryProducts $categoryProducts, CategoryContainer $categoryContainer)
	{
		$this->productServices          = $products;
		$this->categoryContainerService = $categoryContainer;
		$this->categoryServices         = $categories;
		$this->categoryProductServices  = $categoryProducts;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addHidden('produtcIds', $this->ids);
		$form->addComponent($this->categoryContainerService->getContainer(), 'category');

		$form->addSaveCancelControl('saveControl');
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			foreach ($this->products as $product) {
				$categoryProducts = $this->categoryProductServices->em->getRepository(CategoryProduct::class)->findBy(['product' => $product->getId()]);
				foreach ($categoryProducts as $fp) {
					$this->categoryProductServices->em->remove($fp);
				}
				$product->removeAllCategoryProducts();
				$this->em->persist($product);
			}

			$this->em->flush();

			//Categorie
			$categories = $this->categoryContainerService->getFormData($values->category);
			foreach ($categories as $key => $c) {
				foreach ($this->products as $product) {
					if ($c && $key != 'defaultCategory') {
						$res = explode('y', $key);
						$cat = $this->em->getRepository(Category::class)->find($res[1]);
						$product->addCategoryProduct(new CategoryProduct($product, $cat));
					}
					if ($key == 'defaultCategory') {
						$cat = $this->em->getRepository(Category::class)->find($c);
						$product->setDefaultCategory($cat);
					}
				}
			}


			$this->em->flush();
			$form->addCustomData('productIds', $values->produtcIds);
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.productForm.productSaved', Flashes::FLASH_SUCCESS);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setProducts($ids)
	{
		$this->ids  = $ids;
		$productIds = explode('-', $ids);

		$cat       = [];
		$isSameCatDef = true;
		$isSameCat = true;
		foreach ($productIds as $id) {
			$product             = $this->em->getRepository(Product::class)->find($id);
			$this->products[$id] = $product;
			if (!isset($cat['defaultCategory'])) {
				$cat['defaultCategory'] = $product->getDefaultCategory()->getId();
				foreach ($product->getCategoryProducts() as $key => $value) {
					$cat['category' . $value->getIdCategory()] = true;
				}
				continue;
			}
			if ($product->getDefaultCategory()->getId() != $cat['defaultCategory'])
				$isSameCatDef = false;
			foreach ($product->getCategoryProducts() as $key => $value) {
				if (!isset($cat['category' . $value->getIdCategory()]))
					$isSameCat = false;
			}
		}

		if (!$this->products)
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);

		if ($isSameCat && $isSameCatDef)
			$this->categoryContainerService->setDefaults($this['form']['category'], $cat);
		elseif ($isSameCatDef) {
			$c['defaultCategory'] = $cat['defaultCategory'];
			$this->categoryContainerService->setDefaults($this['form']['category'], $c);
		}
	}
}
