<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use EshopCatalog\AdminModule\Components\Features\IFeatureFormFactory;
use EshopCatalog\AdminModule\Components\Features\IFeatureValueFormFactory;
use EshopCatalog\AdminModule\Components\Features\IFeaturesGridFactory;
use EshopCatalog\AdminModule\Components\Features\IFeatureValuesGridFactory;
use EshopCatalog\AdminModule\Components\Variants\IVariantsGridFactory;
use EshopCatalog\AdminModule\Components\Variants\IVariantFormFactory;
use EshopCatalog\AdminModule\Components\Variants\IVariantValueFormFactory;
use EshopCatalog\AdminModule\Components\Variants\IVariantValuesGridFactory;
use EshopCatalog\Model\Entities\Feature;
use EshopCatalog\Model\Entities\FeatureTexts;
use EshopCatalog\AdminModule\Model\Features;
use EshopCatalog\Model\Entities\FeatureValue;
use EshopCatalog\Model\Entities\FeatureValueTexts;
use EshopCatalog\Model\Entities\Variant;
use EshopCatalog\Model\Entities\VariantText;
use EshopCatalog\AdminModule\Model\Variants;
use EshopCatalog\Model\Entities\VariantValue;
use EshopCatalog\Model\Entities\VariantValueText;
use Core\Components\Flashes\Flashes;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\Html;

/**
 * Class VariantsFeaturesPresenter
 * @package EshopCatalog\AdminModule\Presenters
 */
class VariantsFeaturesPresenter extends BasePresenter
{

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.variantsFeatures'));
		$this->setHeader('eshopCatalog.title.variantsFeatures', 'fa fa-list');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.addVariant',
				'link'  => 'VariantsFeatures:addVariant',
				'ico'   => 'plus',
			], [
				'title' => 'eshopCatalog.menu.addVariantValue',
				'link'  => 'VariantsFeatures:addVariantValue',
				'ico'   => 'plus',
			], [
				'title' => 'eshopCatalog.menu.addFeature',
				'link'  => 'VariantsFeatures:addFeature',
				'ico'   => 'plus',
			], [
				'title' => 'eshopCatalog.menu.addFeatureValue',
				'link'  => 'VariantsFeatures:addFeatureValue',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddFeature()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.newFeature'));
		$this->setHeader('eshopCatalog.title.newFeature', 'fa fa-list-alt');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.addFeatureValue',
				'link'  => 'VariantsFeatures:addFeatureValue',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddVariant()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.newVariant'));
		$this->setHeader('eshopCatalog.title.newVariant', 'fa fa-list-alt');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.addVariantValue',
				'link'  => 'VariantsFeatures:addVariantValue',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddFeatureValue()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.newFeatureValue'));
		$this->setHeader('eshopCatalog.title.newFeatureValue', 'fa fa-list-alt');
	}

	public function actionAddVariantValue()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.newVariantValue'));
		$this->setHeader('eshopCatalog.title.newVariantValue', 'fa fa-list-alt');
	}

	public function actionEditFeature($id)
	{
		$feature = $this->em->getRepository(Feature::class)->find($id);

		if (!$feature)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('eshopCatalog.title.editFeature'));
		$this->setHeader('eshopCatalog.title.editFeature', 'fa fa-list-alt');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.addFeatureValue',
				'link'  => 'VariantsFeatures:addFeatureValue',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionEditVariant($id)
	{
		$variant = $this->em->getRepository(Variant::class)->find($id);

		if (!$variant)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('eshopCatalog.title.editVariant'));
		$this->setHeader('eshopCatalog.title.editVariant', 'fa fa-list-alt');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.addVariantValue',
				'link'  => 'VariantsFeatures:addVariantValue',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionEditFeatureValue($id)
	{
		$featureValue = $this->em->getRepository(FeatureValue::class)->find($id);

		if (!$featureValue)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('eshopCatalog.title.editFeatureValue'));
		$this->setHeader('eshopCatalog.title.editFeatureValue', 'fa fa-list-alt');
	}

	public function actionEditVariantValue($id)
	{
		$variantValue = $this->em->getRepository(VariantValue::class)->find($id);

		if (!$variantValue)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('eshopCatalog.title.editVariantValue'));
		$this->setHeader('eshopCatalog.title.editVariantValue', 'fa fa-list-alt');
	}

	public function actionClose($id)
	{
		$this->redirect('Default:');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
	protected function createComponentFeatureForm(IFeatureFormFactory $feature)
	{
		$control = $feature->create();

		if ($this->getParameter('id'))
			$control->setFeature($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:editFeature', $form->getCustomData('featureId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:default');
		};

		return $control;
	}

	protected function createComponentVariantForm(IVariantFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setVariant($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:editVariant', $form->getCustomData('variantId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:default');
		};

		return $control;
	}

	protected function createComponentFeatureValueForm(IFeatureValueFormFactory $factory)
	{
		$control = $factory->create();
		if ($this->getParameter('id'))
			$control->setFeatureValue($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:editFeatureValue', $form->getCustomData('featureValueId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:default');
		};
		$control['form']->onSuccess[]             = function(BaseForm $form) {
			if ($form->isSubmitted()->name == 'saveAndNew')
				$this->redirect('VariantsFeatures:addFeatureValue');
		};

		return $control;
	}

	protected function createComponentVariantValueForm(IVariantValueFormFactory $factory)
	{
		$control = $factory->create();
		if ($this->getParameter('id'))
			$control->setVariantValue($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:editVariantValue', $form->getCustomData('variantValueId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('VariantsFeatures:default');
		};
		$control['form']->onSuccess[]             = function(BaseForm $form) {
			if ($form->isSubmitted()->name == 'saveAndNew')
				$this->redirect('VariantsFeatures:addVariantValue');
		};

		return $control;
	}

	protected function createComponentFeaturesGrid(IFeaturesGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentFeatureValuesGrid(IFeatureValuesGridFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setFeature($this->getParameter('id'));

		return $control;
	}

	protected function createComponentVariantsGrid(IVariantsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentVariantValuesGrid(IVariantValuesGridFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setVariant($this->getParameter('id'));

		return $control;
	}
}
