<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\Products;
use EshopCatalog\Model\Config;
use Nette\Utils\ArrayHash;
use Nette\Utils\Paginator;

/**
 * Class SearchForm
 * @package EshopCatalog\FrontModule\Components
 */
class SearchForm extends BaseControl
{

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();
		$form->setAction($this->getPresenter()->link(':EshopCatalog:Front:Default:search'));
		$form->setMethod('get');

		$form->addText('q', '')->setRequired();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		$this->getPresenter()->redirect(':EshopCatalog:Front:Default:search', ['q' => $values->q]);
	}

	/*******************************************************************************************************************
	 * ============================== Get / Set
	 */
}
