<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Entities\TSeo;
use EshopCatalog\Model\Entities\Manufacturer;
use Gallery\FrontModule\Model\Dao\Album;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

class Product
{
	use MagicAccessors;
	use TSeo;

	/** @var int */
	private $id;

	/** @var int */
	public $quantity;

	/** @var float */
	public $price;

	/** @var float */
	public $retailPrice;

	/** @var int */
	protected $manufacturerId;

	/** @var Manufacturer */
	private $manufacturer;

	/** @var string */
	public $name;

	/** @var string */
	public $shortDescription;

	/** @var string */
	public $description;

	/** @var DateTime */
	public $created;

	/** @var DateTime */
	public $modified;

	/** @var int */
	protected $galleryId;

	/** @var Album */
	private $gallery;

	/** @var VariantsList[] */
	protected $variants;

	/** @var FeatureProduct[] */
	protected $features;

	/** @var self[] */
	protected $related;

	/** @var self[] */
	protected $alternative;

	/** @var int */
	protected $defaultCategory;

	/** @var int[] */
	public $categories;

	/** @var Tag[] */
	public $tags;

	/** @var string */
	public $link = '#';

	/** @var int */
	private $vatRate;

	/** @var string */
	protected $ean;

	/** @var string */
	protected $code1;

	/** @var string */
	protected $code2;

	public function __construct($id)
	{
		$this->id = $id;
	}

	/**
	 * @return int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * @return int
	 */
	public function getQuantity()
	{
		return $this->quantity;
	}

	/**
	 * @param int $quantity
	 */
	public function setQuantity(int $quantity)
	{
		$this->quantity = $quantity;
	}

	public function getPrice(): float
	{
		return (float) $this->price;
	}

	public function setPrice(float $price)
	{
		$this->price = $price;
	}

	public function getRetailPrice(): float
	{
		return (float) $this->retailPrice;
	}

	/**
	 * @param float $retailPrice
	 */
	public function setRetailPrice(float $retailPrice)
	{
		$this->retailPrice = $retailPrice;
	}

	/**
	 * @return Manufacturer
	 */
	public function getManufacturer()
	{
		return $this->manufacturer;
	}

	/**
	 * @param mixed $manufacturer
	 */
	public function setManufacturer($manufacturer)
	{
		$this->manufacturer = $manufacturer;
	}

	/**
	 * @return string
	 */
	public function getName()
	{
		return $this->name;
	}

	/**
	 * @param string $name
	 */
	public function setName($name)
	{
		$this->name = $name;
	}

	/**
	 * @return string
	 */
	public function getDescription()
	{
		return $this->description;
	}

	/**
	 * @param string $description
	 */
	public function setDescription($description)
	{
		$this->description = $description;
	}

	/**
	 * @return mixed
	 */
	public function getGallery()
	{
		return $this->gallery;
	}

	/**
	 * @param mixed $gallery
	 */
	public function setGallery($gallery)
	{
		$this->gallery = $gallery;
	}

	/**
	 * @return ProductVariant[]
	 */
	public function getVariants()
	{
		return $this->variants;
	}

	/**
	 * @param ProductVariant[] $variants
	 */
	public function setVariants($variants)
	{
		$this->variants = $variants;
	}

	/**
	 * @param FeatureProduct[] $features
	 */
	public function setFeatures($features)
	{
		$this->features = $features;
	}

	/**
	 * @return FeatureProduct[]
	 */
	public function getFeatures() { return $this->features; }

	/**
	 * @param string $type
	 *
	 * @return Tag|null
	 */
	public function getTag($type) { return $this->tags[$type] ?? null; }

	/**
	 * @param self[] $array
	 *
	 * @return $this
	 */
	public function setAlternatives($array)
	{
		$this->alternative = $array;

		return $this;
	}

	/** @return int */
	public function getVatRate()
	{
		return $this->vatRate;
	}

	/**
	 * @param int $vatRate
	 *
	 * @return Product
	 */
	public function setVatRate($vatRate): Product
	{
		$this->vatRate = $vatRate;

		return $this;
	}

	/** @return string */
	public function getEan()
	{
		return $this->ean;
	}

	/**
	 * @param string $ean
	 *
	 * @return Product
	 */
	public function setEan($ean): Product
	{
		$this->ean = $ean;

		return $this;
	}

	/**
	 * @return string
	 */
	public function getCode1()
	{
		return $this->code1;
	}

	/**
	 * @param $code1
	 *
	 * @return Product
	 */
	public function setCode1($code1): Product
	{
		$this->code1 = $code1;

		return $this;
	}

	/**
	 * @return string
	 */
	public function getCode2()
	{
		return $this->code2;
	}

	/**
	 * @param $code2
	 *
	 * @return Product
	 */
	public function setCode2($code2): Product
	{
		$this->code2 = $code2;

		return $this;
	}

	public function getDefaultCategory(): ?int { return $this->defaultCategory; }

	public function setDefaultCategory(int $id): self
	{
		$this->defaultCategory = $id;

		return $this;
	}
}
