<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Core\Model\Helpers\BaseService;
use EshopCatalog\FrontModule\Model\Dao\Product;

/**
 * Class HeurekaXml
 * @package EshopCatalog\Model
 */
class HeurekaXmlService extends BaseService
{
	/** @var string */
	public $baseUrl;

	/** @var Categories */
	protected $categoriesService;

	public function __construct(Categories $categories)
	{
		$this->categoriesService = $categories;
	}

	/** @param string $baseUrl */
	public function setBaseUrl($baseUrl)
	{
		$this->baseUrl = $baseUrl;
	}

	/**
	 * @param Product $product
	 *
	 * @return \DOMDocument xml SHOPITEM
	 */
	public function createXmlShopitem($product)
	{
		$dom               = new \DOMDocument();
		$dom->formatOutput = true;
		$dom->encoding     = 'utf-8';
		$shopitem          = $dom->createElement('SHOPITEM');

		$child = $dom->createElement('ITEM_ID', (string) $product->getId());
		$shopitem->appendChild($child);

		$child     = $dom->createElement('PRODUCTNAME');
		$childText = $dom->createTextNode((string) $product->getName());
		$child->appendChild($childText);
		$shopitem->appendChild($child);

		$child     = $dom->createElement('PRODUCT');
		$childText = $dom->createTextNode((string) $product->getName());
		$child->appendChild($childText);
		$shopitem->appendChild($child);

		$child     = $dom->createElement('DESCRIPTION');
		$childText = $dom->createTextNode((string) $product->getDescription());
		$child->appendChild($childText);
		$shopitem->appendChild($child);

		$child = $dom->createElement('URL', (string) $product->link);
		$shopitem->appendChild($child);

		$child = $dom->createElement('PRICE_VAT', number_format($product->getPrice(), 2, ".", ""));
		$shopitem->appendChild($child);

		$child = $dom->createElement('DELIVERY_DATE', ($product->quantity > 0) ? '0' : '30');
		$shopitem->appendChild($child);

		if ($product->getGallery() && $product->getGallery()->cover) {
			$child = $dom->createElement('IMGURL', (string) ($this->baseUrl . $product->getGallery()->cover->file));
			$shopitem->appendChild($child);
		}

		if ($product->getEan()) {
			$child = $dom->createElement('EAN', (string) $product->getEan());
			$shopitem->appendChild($child);
		}

		if ($product->getDefaultCategory()) {
			$category = $this->categoriesService->get($product->getDefaultCategory());
			$child    = $dom->createElement('CATEGORYTEXT', (string) $category->name);
			$shopitem->appendChild($child);
		}

		if ($product->getManufacturer() && trim($product->getManufacturer()->name)) {
			$child = $dom->createElement('MANUFACTURER', (string) $product->getManufacturer()->name);
			$shopitem->appendChild($child);
		}

		$dom->appendChild($shopitem);

		return $dom;
	}
}
