<?php declare(strict_types = 1);


namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="eshop_catalog__product_export", indexes={
 *     @ORM\Index(name="id_name", columns={"id"})
 * })
 * @ORM\Entity
 * @ORM\EntityListeners({"ManufacturerListener"})
 */
class ProductExport
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var int
	 * @ORM\Column(name="is_zbozi", type="smallint", length=1, )
	 */
	public $isZbozi;

	/**
	 * @var int
	 * @ORM\Column(name="is_heureka", type="smallint", length=1)
	 */
	public $isHeureka;

	/**
	 * @var int
	 * @ORM\Column(name="is_google", type="smallint", length=1)
	 */
	public $isGoogle;

	public function __construct()
	{
		$this->isZbozi   = 0;
		$this->isHeureka = 0;
		$this->isGoogle  = 0;
	}
}
