<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Kdyby\Events\Subscriber;
use Nette\Caching\Cache;
use Nette\SmartObject;

/**
 * Class CategoryFilterListener
 * @package EshopCatalog\Model\Entities
 */
class CategoryFilterListener implements Subscriber
{
	use SmartObject;

	/** @var CacheService */
	protected $cacheService;

	public function __construct(CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param CategoryFilter     $categoryFilter
	 * @param LifecycleEventArgs $event
	 *
	 * @throws Doctrine\ORM\ORMException
	 */
	public function postHandler(CategoryFilter $categoryFilter, LifecycleEventArgs $event)
	{
		$this->cacheService->clean('category', [Cache::TAGS => ['category/' . $categoryFilter->category->getId()]]);
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param CategoryFilter     $categoryFilter
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($categoryFilter, $args)
	{
		$this->cacheService->clean('category', [Cache::TAGS => ['category/' . $categoryFilter->category->getId()]]);
	}
}
