<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use EshopCatalog\FrontModule\Model\Categories;
use EshopCatalog\FrontModule\Model\Products;
use Nette\Localization\ITranslator;

class CategoryWithProducts extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'eshopCatalogCategoryWithProducts';

	/** @var Products */
	protected $productsService;

	/** @var Categories */
	protected $categoriesService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(Products $products, Categories $categories, ITranslator $translator)
	{
		$this->productsService   = $products;
		$this->categoriesService = $categories;
		$this->translator        = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
	}

	public function render($params)
	{
		if (!isset($params['toVar']))
			throw new InvalidArgumentException('Need variable for output');
		if (!isset($params['categoryId']))
			throw new InvalidArgumentException('Need categoryId for output');

		return [
			'category' => $this->categoriesService->get((int) $params['categoryId']),
			'products' => $this->productsService->getProductsInCategory((int) $params['categoryId'], 0, $params['limit'] ?? null, null, [], ['loadPrice' => true]),
		];
	}
}
