<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Kdyby\Events\Subscriber;
use Navigations\Model\Navigations;
use Nette\Localization\ITranslator;
use Nette\Caching\Cache;
use Nette\SmartObject;

class CategoryTextListener implements Subscriber
{
	use SmartObject;

	/** @var array */
	protected static $cleared = [];

	/** @var CacheService */
	protected $cacheService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(ITranslator $translator, CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	/**
	 * Zkontrolované cache, takto OK
	 * 
	 * @ORM\PostUpdate
	 *
	 * @param CategoryTexts      $categoryText
	 * @param LifecycleEventArgs $event
	 *
	 * @throws Doctrine\ORM\ORMException
	 */
	public function postUpdateHandler(CategoryTexts $categoryText, LifecycleEventArgs $event)
	{
		if (!self::$cleared[$categoryText->getCategory()->getId()]) {
			$em        = $event->getEntityManager();
			$changeSet = $em->getUnitOfWork()->getEntityChangeSet($categoryText);

			if (isset($changeSet['alias'])) {
				$this->cacheService->clean('navigation', [
					Cache::TAGS => [Navigations::CACHE_NAMESPACE],
				]);
			}
		}

		self::$cleared[$categoryText->getCategory()->getId()] = true;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param CategoryTexts      $categoryText
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($categoryText, $args)
	{
	}
}
