<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use Core\Model\Helpers\Traits\TPublish;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\Feature;
use EshopCatalog\Model\Entities\FeatureValue;
use Nette\Caching\Cache;

/**
 * Class Features
 * @package EshopCatalog\AdminModule\Model
 *
 * @method Feature|null|object = getReference($id)
 * @method Feature[]|null getAll()
 * @method Feature|null get($id)
 */
class Features extends BaseEntityService
{
	use TPublish;
	use TPosition;

	/** @var CacheService @inject */
	public $cacheService;

	protected $entityClass = Feature::class;

	/**
	 * @param int $id
	 * @param int $state
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setUseAsFilter($id, $state)
	{
		if ($item = $this->get($id)) {
			$item->useAsFilter = $state;
			$this->em->persist($item)->flush();

			return true;
		}

		return false;
	}

	/**
	 * @param int $id
	 * @param int $position
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setPosition($id, $position)
	{
		if ($item = $this->getReference($id)) {
			$item->setPosition((int) $position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function mergeAll()
	{
		$delete = [];
		foreach ($this->getEr()->createQueryBuilder('f')->select('f.id')
			         ->leftJoin('f.featureTexts', 'ft')->where('ft IS NULL')->getQuery()->getArrayResult() as $row)
			$delete[] = $row['id'];

		foreach (array_chunk($delete, 200) as $chunk)
			$this->em->createQuery('DELETE FROM ' . $this->entityClass . ' f WHERE f.id IN (:id)')->setParameter('id', $chunk)->execute();
		$delete = null;

		$fks = [];
		foreach ($this->em->getConnection()->fetchAll("
				SELECT *
					FROM information_schema.KEY_COLUMN_USAGE
					WHERE
  						REFERENCED_TABLE_NAME = 'eshop_catalog__feature'
  						AND REFERENCED_COLUMN_NAME = 'id'
  						AND CONSTRAINT_SCHEMA = '{$this->em->getConnection()->getDatabase()}'") as $tmp) {
			if ($tmp['TABLE_NAME'] == 'eshop_catalog__feature_texts')
				continue;

			$fks[] = $tmp;
		}

		//TODO lang
		foreach ($this->getEr()->createQueryBuilder('f')->select('ft.name, count(f.id)')
			         ->join('f.featureTexts', 'ft', 'WITH', 'ft.lang = \'cs\'')
			         ->groupBy('ft.name')->having('count(f.id) > 1')
			         ->getQuery()->getArrayResult() as $duplicate) {

			$ids = [];
			foreach ($this->getEr()->createQueryBuilder('f')->select('f.id')->where('ft.name = :name')->setParameter('name', $duplicate['name'])
				         ->join('f.featureTexts', 'ft', 'WITH', 'ft.lang = \'cs\'')
				         ->getQuery()->getArrayResult() as $tmp)
				$ids[] = $tmp['id'];

			$first = array_shift($ids);

			$this->em->getConnection()->update('eshop_catalog__feature_value', ['feature_id' => $first], ['feature_id' => $ids]);

			foreach ($fks as $fk) {
				$this->em->getConnection()->update($fk['TABLE_NAME'], [$fk['COLUMN_NAME'] => $first], [$fk['COLUMN_NAME'] => $ids]);
			}

			$this->em->createQuery('DELETE FROM ' . $this->entityClass . ' f WHERE f.id IN(:id)')->setParameter('id', $ids)->execute();
		}

		$this->cacheService->defaultCache->clean([Cache::TAGS => ['features']]);
	}
}

