<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class VariantValueText
 * @package EshopCatalog\Model\Entities
 *
 * @ORM\Table(name="eshop_catalog__variant_value_text", indexes={
 *     @ORM\Index(name="lang_id_name", columns={"lang", "variant_value_id", "name"})
 * })
 * @ORM\Entity
 * @ORM\EntityListeners({"VariantValueListener"})
 */
class VariantValueText
{
	/**
	 * @var Variant
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="VariantValue", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="variant_value_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $variantValue;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	private $lang;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	public $name;

	/**
	 * VariantValueText constructor.
	 *
	 * @param Variant $variant
	 * @param string  $lang
	 */
	public function __construct(VariantValue $variantValue, string $lang)
	{
		$this->variantValue = $variantValue;
		$this->lang         = $lang;
	}

	/**
	 * @return VariantValue
	 */
	public function getVariantValue() { return $this->variantValue; }

	/**
	 * @return string
	 */
	public function getLang() { return $this->lang; }
}

