<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use Core\Model\Helpers\Traits\TPublish;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\Manufacturer;
use Nette\Caching\Cache;

/**
 * Class Manufacturers
 * @package EshopCatalog\AdminModule\Model
 *
 * @method Manufacturer|null|object = getReference($id)
 * @method Manufacturer[]|null getAll()
 * @method Manufacturer|null get($id)
 */
class Manufacturers extends BaseEntityService
{
	use TPublish;
	use TPosition;

	protected $entityClass = Manufacturer::class;

	/** @var CacheService */
	protected $cacheService;

	public function __construct(CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
	}

	/**
	 * @throws \Doctrine\DBAL\DBALException
	 */
	public function mergeAll()
	{
		$fks = [];
		foreach ($this->em->getConnection()->fetchAll("
				SELECT *
					FROM information_schema.KEY_COLUMN_USAGE
					WHERE
  						REFERENCED_TABLE_NAME = 'eshop_catalog__manufacturer'
  						AND REFERENCED_COLUMN_NAME = 'id'
  						AND CONSTRAINT_SCHEMA = '{$this->em->getConnection()->getDatabase()}'") as $tmp) {
			if ($tmp['TABLE_NAME'] == 'eshop_catalog__manufacturer_texts')
				continue;

			$fks[] = $tmp;
		}

		foreach ($this->getEr()->createQueryBuilder('m')->select('m.name, count(m.id)')->groupBy('m.name')->having('count(m.id) > 1')
			         ->getQuery()->getArrayResult() as $duplicate) {

			$ids = [];
			foreach ($this->getEr()->createQueryBuilder('m')->select('m.id')->where('m.name = :name')->setParameter('name', $duplicate['name'])
				         ->getQuery()->getArrayResult() as $tmp)
				$ids[] = $tmp['id'];

			$first = array_shift($ids);

			foreach ($fks as $fk) {
				$this->em->getConnection()->update($fk['TABLE_NAME'], [$fk['COLUMN_NAME'] => $first], [$fk['COLUMN_NAME'] => $ids]);
			}

			$this->em->createQuery('DELETE FROM ' . $this->entityClass . ' m WHERE m.id IN (:id)')->setParameter('id', $ids)->execute();
		}

		$this->cacheService->defaultCache->clean([Cache::TAGS => ['manufacturers']]);
	}
}
