<?php declare(strict_types = 1);


namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\MagicAccessors;
use EshopCatalog\Model\Helpers\ExportEnums;

/**
 * @ORM\Table(name="eshop_catalog__product_export")
 * @ORM\Entity
 */
class ProductExport
{
	use MagicAccessors;

	/**
	 * @var Product
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", nullable=false)
	 */
	public $id;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=false)
	 */
	public $lang;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="service", type="string", nullable=false)
	 */
	protected $service;

	/**
	 * @var int
	 * @ORM\Column(name="status", type="smallint", options={"default": 2})
	 */
	public $status;

	/**
	 * @var string
	 * @ORM\Column(name="product", type="string", nullable=true)
	 */
	public $product;

	/**
	 * @var string
	 * @ORM\Column(name="product_name", type="string", nullable=true)
	 */
	public $productName;

	/**
	 * @var string
	 * @ORM\Column(name="category_text", type="string", nullable=true)
	 */
	public $categoryText;

	/**
	 * @var float
	 * @ORM\Column(name="bid_cpc", type="decimal", precision=10, scale=2, nullable=true)
	 */
	public $bidCpc;

	public function __construct(Product $id, string $lang, string $service)
	{
		$this->id   = $id;
		$this->lang = $lang;
		$this->setService($service);
		$this->status = ExportEnums::STATUS_INHERIT;
	}

	public function setService(string $service): self
	{
		if (ExportEnums::validateService($service))
			$this->service = $service;

		return $this;
	}
}
