<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class ProductVariantSupplier
 * @package EshopCatalog\Model\Entities
 *
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__product_variant_supplier")
 */
class ProductVariantSupplier
{
	use MagicAccessors;

	/**
	 * @var Supplier
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Supplier")
	 * @ORM\JoinColumn(name="id_supplier", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $supplier;

	/**
	 * @var ProductVariant
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="ProductVariant")
	 * @ORM\JoinColumn(name="id_product_variant", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $productVariant;

	/**
	 * @var int
	 * @ORM\Column(name="quantity", type="integer")
	 */
	public $quantity;

	/**
	 * ProductVariantSupplier constructor.
	 *
	 * @param $supplier
	 * @param $productVariant
	 */
	public function __construct($supplier, $productVariant)
	{
		$this->supplier       = $supplier;
		$this->productVariant = $productVariant;
		$this->quantity       = 0;
	}

	/**
	 * @return Supplier
	 */
	public function getSupplier() { return $this->supplier; }

	/**
	 * @return ProductVariant
	 */
	public function getProductVariant() { return $this->productVariant; }
}
