<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class VariantText
 * @package EshopCatalog\Model\Entities
 *
 * @ORM\Table(name="eshop_catalog__variant_text", indexes={
 *     @ORM\Index(name="lang_id_name", columns={"lang", "variant_id", "name"})
 * })
 * @ORM\Entity
 * @ORM\EntityListeners({"VariantListener"})
 */
class VariantText
{
	/**
	 * @var Variant
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Variant", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="variant_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $variant;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	private $lang;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	public $name;

	/**
	 * VariantText constructor.
	 *
	 * @param Variant $variant
	 * @param string  $lang
	 */
	public function __construct(Variant $variant, string $lang)
	{
		$this->variant = $variant;
		$this->lang    = $lang;
	}

	/**
	 * @return Variant
	 */
	public function getVariant() { return $this->id; }

	/**
	 * @return string
	 */
	public function getLang() { return $this->lang; }
}

