<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use EshopCatalog\FrontModule\Model\ProductQuery;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use EshopCatalog\Model\Entities\Product;
use Kdyby\Doctrine\EntityManager;
use Nette\Localization\ITranslator;

class ProductsWithTag extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'eshopCatalogProductsWithTag';

	/** @var ProductsFacade */
	protected $productsFacade;

	/** @var EntityManager */
	protected $em;

	/** @var ITranslator */
	protected $translator;

	public function __construct(ProductsFacade $productsFacade, EntityManager $entityManager, ITranslator $translator)
	{
		$this->productsFacade = $productsFacade;
		$this->em             = $entityManager;
		$this->translator     = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
	}

	public function render($params)
	{
		if (!isset($params['toVar']))
			throw new InvalidArgumentException('Need variable for output');
		if (!isset($params['tag']))
			throw new InvalidArgumentException('Need tag for output');
		if (!isset($params['limit']))
			throw new InvalidArgumentException('Need limit for output');

		$query = (new ProductQuery($this->translator->getLocale()))
			->withTexts(false)
			->withTag($params['tag'])
			->selectIds();

		$ids = array_map(function($r) { return $r['id']; }, $query->getQueryBuilder($this->em->getRepository(Product::class))
			->orderBy('RAND()')->getQuery()
			->setMaxResults($params['limit'])->useResultCache(true, 60)->getScalarResult());

		return $this->productsFacade->getProducts($ids);
	}
}
