import autoComplete from "core/../node_modules/@tarekraafat/autocomplete.js/src/models/autoComplete"

let exportsLoaded  = [];
let exportsLastXhr = [];
const exportUrls   = {
	heureka: 'https://api-evidence.pshk.cz/v1/cms/heureka-export-categories',
	zbozi  : 'https://api-evidence.pshk.cz/v1/cms/zbozi-export-categories',
	google : 'https://api-evidence.pshk.cz/v1/cms/google-export-categories',
};

document.addEventListener('DOMContentLoaded', () => {
	initCategoryFilter();
	initInputs();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		setTimeout(() => {
			initCategoryFilter();
		}, 5000);
		initCategoryFilter();
		initInputs();
	});

	global.naja.addEventListener('complete', e => {
		initCategoryFilter();
		initInputs();
	});
});

const initCategoryFilter = () => {
	let productsGridForm = document.getElementById('frm-productsGrid-grid-filter');

	if (!productsGridForm)
		return;

	productsGridForm.querySelectorAll('[name="filter[defaultCategory]"]:not(.init)').forEach(el => {
		el.classList.add('init');

		el.addEventListener('change', () => {
			let data = new FormData(el.form);
			global.naja.makeRequest('post', el.form.action, data);
		});
	});
};

const initInputs = () => {
	document.querySelectorAll('[data-grader-type]:not(.init)').forEach(input => {
		input.classList.add('init');
		let type    = input.dataset.graderType;
		let inputId = input.id;
		let targetInput;

		if (input.dataset.contentLang)
			targetInput = document.querySelector('[name="' + input.dataset.graderId + '_' + input.dataset.contentLang + ']"]');
		 else
			targetInput = document.querySelector('[name="' + input.dataset.graderId + '"]');

		if (!exportUrls[type])
			return true;

		input.parentElement.style.position = 'relative';

		new autoComplete({
			data       : {
				src  : async () => {
					if (exportsLoaded[type])
						return exportsLoaded[type];

					if (typeof exportsLastXhr[type] !== 'undefined' && exportsLastXhr[type].hasOwnProperty('abort'))
						exportsLastXhr[type].abort();

					let source = await fetch(exportUrls[type], {
						method: 'GET',
					});

					const data = await source.json();

					if (targetInput.value && data.data[targetInput.value] !== undefined)
						input.value = data.data[targetInput.value];
					exportsLastXhr[type] = [];
					for (let a in data.data) {
						exportsLastXhr[type][a] = {
							name: data.data[a],
						};
					}
					return exportsLastXhr[type];
				},
				key  : ['name'],
				cache: true,
			},
			cache      : false,
			selector   : '#' + inputId,
			maxResults : 20,
			threshold  : 2,
			resultsList: {
				render     : true,
				destination: input,
				position   : "afterend",
				element    : "ul"
			},
			resultItem : {
				content: (data, source) => {
					source.innerHTML = data.index + ' | ' + data.value.name;
				},
				element: "li"
			},
			onSelection: feedback => {
				targetInput.value = feedback.selection.index;
				input.value       = feedback.selection.value.name;
			}
		});
	});
};
