<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Core\Model\Helpers\BaseService;
use EshopCatalog\FrontModule\Model\Export\Data;
use EshopCatalog\FrontModule\Model\Export\XmlExportCollection;
use EshopCatalog\FrontModule\Model\Provider\IXmlExportService;
use Kdyby\Doctrine\EntityManager;
use Nette\Http\Request;
use Tracy\Debugger;

class ExportFacade extends BaseService
{
	/** @var EntityManager */
	protected $em;

	/** @var XmlExportCollection */
	protected $xmlExport;

	/** @var Request */
	protected $httpRequest;

	/** @var Data */
	protected $dataService;

	public function __construct(EntityManager $em, XmlExportCollection $xmlExport, Request $request, Data $data)
	{
		$this->em          = $em;
		$this->xmlExport   = $xmlExport;
		$this->httpRequest = $request;
		$this->dataService = $data;
	}

	public function generateExport(array $types = [])
	{
		// Naštení vybraných exportů
		/** @var IXmlExportService[] $services */
		$services = [];
		foreach ($this->xmlExport->getServices() as $k => $v)
			if (in_array($k, $types))
				$services[$k] = $v;

		// Inicializace exportu
		$baseUrl = substr($this->httpRequest->getUrl()->getBaseUrl(), 0, -1);
		foreach ($services as $service) {
			$service->setBaseUrl($baseUrl);
			$service->startExport();
		}

		$i         = 1;
		$start     = 0;
		$limit     = 1000;
		$loop      = 1;
		$loopLimit = 100;
		$products  = $this->dataService->getProductsData($start, $limit);
		while ($products && $loop <= $loopLimit) {
			foreach ($products as $product)
				foreach ($services as $service)
					$service->writeItem($product);

			$start    = $limit * $i++;
			$products = $this->dataService->getProductsData($start, $limit);
			$loop++;
		}

		foreach ($services as $service)
			$service->endExport();
	}
}
