<?php declare(strict_types = 1);

namespace EshopCatalog\DI;

use Core\DI\CompilerExtension;
use EshopCatalog\FrontModule\Model\Provider\IXmlExportService;
use Nette;

class EshopCatalogExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopCatalog' => 'EshopCatalog\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$builder->getDefinition('eshopCatalog.front.xmlExportCollection')
			->addSetup(new Nette\DI\Statement('$service->setServices(?)', [$builder->findByType(IXmlExportService::class)]));
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopCatalog\Model\Config::setParams(?);', [$builder->parameters['eshopCatalog']]);
		$init->addBody('$this->getService(\'eshopCatalog.front.categories\')->linkGenerator = $this->getService(\'application.linkGenerator\');');
		$init->addBody('$this->getService(\'eshopCatalog.front.products\')->linkGenerator = $this->getService(\'application.linkGenerator\');');
		$init->addBody('$this->getService(\'eshopCatalog.front.productsFacade\')->linkGenerator = $this->getService(\'application.linkGenerator\');');
	}
}
