<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use EshopCatalog\FrontModule\Model\Categories;
use EshopCatalog\FrontModule\Model\Products;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use Nette\Localization\ITranslator;

class CategoryWithProducts extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'eshopCatalogCategoryWithProducts';

	/** @var Products */
	protected $productsService;

	/** @var ProductsFacade */
	protected $productsFacade;

	/** @var Categories */
	protected $categoriesService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(Products $products, ProductsFacade $productsFacade, Categories $categories, ITranslator $translator)
	{
		$this->productsService   = $products;
		$this->productsFacade    = $productsFacade;
		$this->categoriesService = $categories;
		$this->translator        = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
	}

	public function render($params)
	{
		if (!isset($params['toVar']))
			throw new InvalidArgumentException('Need variable for output');
		if (!isset($params['categoryId']))
			throw new InvalidArgumentException('Need categoryId for output');

		$ids = $this->productsService->getProductsIdInCategory((int) $params['categoryId'], 0, $params['limit'] ?? null);

		return [
			'category' => $this->categoriesService->get((int) $params['categoryId']),
			'products' => $ids ? $this->productsFacade->getProducts($ids) : [],
		];
	}
}
