import autoComplete from "core/../node_modules/@tarekraafat/autocomplete.js/src/models/autoComplete"

let exportsLoaded = [];
let exportsLastXhr = [];
const exportUrls = {
	heureka: 'https://api-evidence.pshk.cz/v1/cms/heureka-export-categories',
	zbozi: 'https://api-evidence.pshk.cz/v1/cms/zbozi-export-categories',
	google: 'https://api-evidence.pshk.cz/v1/cms/google-export-categories',
};

document.addEventListener('DOMContentLoaded', () => {
	initInputs();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initInputs();
	});

	global.naja.addEventListener('complete', e => {
		initInputs();
	});
});

const initInputs = () => {
	document.querySelectorAll('[data-grader-type]:not(.init)').forEach(input => {
		input.classList.add('init');
		let type = input.dataset.graderType;
		let inputId = input.id;

		if (!exportUrls[type])
			return true;

		input.parentElement.style.position = 'relative';

		let dataLoader = new autoComplete({
			data: {
				src: () => {
					if (exportsLoaded[type])
						return exportsLoaded[type];

					if (typeof exportsLastXhr[type] !== 'undefined' && exportsLastXhr[type].hasOwnProperty('abort'))
						exportsLastXhr[type].abort();

					exportsLastXhr[type] = global.naja.makeRequest('get', exportUrls[type], [], {
						history: false,
					}).then(e => {
						console.log(e);
						exportsLastXhr[type] = undefined;
						exportsLoaded[type] = Object.keys(e.data).map(i => e[i]);
						console.log(exportsLoaded[type]);

						return exportsLoaded[type];
					});

					return exportsLastXhr[type];
				},
				key: ['name'],
				cache: true,
			},
			cache: false,
			selector: '#' + inputId,
			maxResults: 20,
			threshold: 2,
			resultsList: {
				render: true,
				destination: input,
				position: "afterend",
				element: "ul"
			},
			resultItem: {
				content: (data, source) => {
					source.innerHTML = data.value.name;
				},
				element: "li"
			},
			onSelection: feedback => {
				console.log(feedback.selection);
				// input.value = feedback.selection.value.id;
				// input.value = feedback.selection.value.code1 + ' | ' + feedback.selection.value.name;
				// inputName.value = feedback.selection.value.name;
			}
		});
	});

	// let categoryGiftForm = document.getElementById('eshopGifts_categoryGiftForm');
	//
	// if (!categoryGiftForm || categoryGiftForm.classList.contains('init'))
	// 	return;
	//
	// categoryGiftForm.classList.add('init');
	// let inputId = 'categoryGiftForm_product';
	// let input = document.getElementById(inputId);
	// let inputValue = categoryGiftForm.querySelector('[name="productId"]');
	// let inputName = categoryGiftForm.querySelector('[name="name"]');
	// let exportsLastXhr;
	//
	// input.parentElement.style.position = 'relative';
	//
	// const dataLoader = new autoComplete({
	// 	data: {
	// 		src: () => {
	// 			if (categoryGiftFormDataLoaded)
	// 				return categoryGiftFormDataLoaded;
	//
	// 			if (typeof exportsLastXhr !== 'undefined' && exportsLastXhr.hasOwnProperty('abort'))
	// 				exportsLastXhr.abort();
	//
	// 			exportsLastXhr = global.naja.makeRequest('get', input.getAttribute('data-link'), [], {
	// 				history: false,
	// 			}).then(e => {
	// 				exportsLastXhr = undefined;
	// 				categoryGiftFormDataLoaded = Object.keys(e).map(i => e[i]);
	// 				console.log(categoryGiftFormDataLoaded);
	//
	// 				return categoryGiftFormDataLoaded;
	// 			});
	//
	// 			return exportsLastXhr;
	// 		},
	// 		key: ['code1', 'name', 'ean'],
	// 		cache: true,
	// 	},
	// 	cache: false,
	// 	selector: '#' + inputId,
	// 	maxResults: 20,
	// 	threshold: 2,
	// 	resultsList: {
	// 		render: true,
	// 		destination: input,
	// 		position: "afterend",
	// 		element: "ul"
	// 	},
	// 	resultItem: {
	// 		content: (data, source) => {
	// 			source.innerHTML = data.value.code1 + ' | ' + data.value.name;
	// 		},
	// 		element: "li"
	// 	},
	// 	onSelection: feedback => {
	// 		inputValue.value = feedback.selection.value.id;
	// 		input.value = feedback.selection.value.code1 + ' | ' + feedback.selection.value.name;
	// 		inputName.value = feedback.selection.value.name;
	// 	}
	// });


	// let productsMap = {};
	//
	// let productFinder2 = () => {
	// 	return function findMatches(query, callbackSync, callback) {
	// 		// $.nette.ajax({
	// 		// 	url: input.dataset.link,
	// 		// 	data: {
	// 		// 		'categoryGiftForm-term': query
	// 		// 	},
	// 		// 	async: true,
	// 		// 	success: function (data) {
	// 		// 		let matches = [];
	// 		// 		$.each(data, function (idx, product) {
	// 		// 			productsMap[product.name] = product;
	// 		// 			matches.push(product.name)
	// 		// 		});
	// 		// 		callback(matches);
	// 		// 	}
	// 		// });
	// 	};
	// };
	//
	// input.typeahead({
	// 		hint: false,
	// 		highlight: true,
	// 		minLength: 3
	// 	},
	// 	{
	// 		name: 'states',
	// 		limit: 100,
	// 		source: productFinder2()
	//
	// 	}).bind('typeahead:select', function (ev, suggestion) {
	// 	console.log(productsMap[suggestion]);
	// 	// $('input[name="productId"]').val(productsMap[suggestion].id);
	// 	// $('input[name="code1"]').val(productsMap[suggestion].code1);
	// 	// $('input[name="price"]').val(productsMap[suggestion].price);
	// 	// $('input[name="vatRate"]').val(productsMap[suggestion].vatRate);
	// });
};
