import autoComplete from "core/../node_modules/@tarekraafat/autocomplete.js/src/models/autoComplete"

document.addEventListener('DOMContentLoaded', () => {
	initCategoryFilter();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		setTimeout(() => {
			initCategoryFilter();
		}, 5000);
		initCategoryFilter();
	});

	global.naja.addEventListener('complete', e => {
		initCategoryFilter();
	});
});

const initCategoryFilter = () => {
	let productsGridForm = document.getElementById('frm-productsGrid-grid-filter');

	if (!productsGridForm)
		return;

	productsGridForm.querySelectorAll('[name="filter[defaultCategory]"]:not(.init)').forEach(el => {
		el.classList.add('init');

		el.addEventListener('change', () => {
			let data = new FormData(el.form);
			global.naja.makeRequest('post', el.form.action, data);
		});
	});
};
