<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use EshopCatalog\Model\Entities\Product;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\AdminModule\Model\Categories;
use EshopCatalog\AdminModule\Model\CategoryProducts;

class ProductsCategoryForm extends BaseControl
{
	/** @var array */
	public $products;

	/** @var string */
	private $ids;

	/** @var Products */
	protected $productServices;

	/** @var \EshopCatalog\AdminModule\Model\CategoryProducts */
	protected $categoryProductServices;

	/** @var \EshopCatalog\AdminModule\Model\Categories */
	protected $categoryServices;

	/** @var CategoryContainer */
	protected $categoryContainerService;

	public function __construct(Products $products, Categories $categories, CategoryProducts $categoryProducts, CategoryContainer $categoryContainer)
	{
		$this->productServices          = $products;
		$this->categoryContainerService = $categoryContainer;
		$this->categoryServices         = $categories;
		$this->categoryProductServices  = $categoryProducts;
	}

	public function render()
	{
		$this->template->thisForm = $this['form'];
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addHidden('produtcIds', $this->ids);
		$form->addComponent($this->categoryContainerService->getContainer(), 'category');

		$form->addSaveCancelControl('saveControl');
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		$this->em->beginTransaction();
		try {
			$this->categoryContainerService->saveData(array_keys($this->products), (array) $values->category);
			$this->em->flush();
			$this->em->commit();

			$form->addCustomData('productIds', $values->produtcIds);
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.productForm.productSaved', Flashes::FLASH_SUCCESS);
		} catch (\Exception $e) {
			if ($this->em->getConnection()->isTransactionActive())
				$this->em->rollback();
			$form->addError($e->getMessage());

			return false;
		}

		return true;
	}

	public function setProducts($ids)
	{
		$this->ids  = $ids;
		$productIds = explode('-', $ids);

		$cat = [];
		foreach ($productIds as $id) {
			$product             = $this->em->getRepository(Product::class)->find($id);
			$this->products[$id] = $product;

			if (!isset($cat['defaultCategory']) && $product->getDefaultCategory())
				$cat['defaultCategory'] = $product->getDefaultCategory()->getId();

			foreach ($product->getCategoryProducts() as $value) {
				$cat['category'][] = (int) $value->getIdCategory();
			}
		}

		if (!empty($cat['category']))
			$cat['category'] = array_unique($cat['category']);

		if (!$this->products)
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);

		$this->categoryContainerService->setDefaults($this['form'], $cat);
	}
}
