<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Suppliers;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Nette\Utils\Html;
use EshopCatalog\Model\Entities\Supplier;
use EshopCatalog\Model\Entities\SupplierTexts;
use EshopCatalog\AdminModule\Model\Suppliers;

class SuppliersGrid extends BaseControl
{
    /** @var Suppliers */
    protected $supplierServices;

    public function __construct(Suppliers $suppliers)
    {
        $this->supplierServices = $suppliers;
    }

    public function render()
    {
        $this->template->setFile(__DIR__ . '/SuppliersGrid.latte');
        $this->template->render();
    }

    protected function createComponentGrid()
    {
        $grid = $this->createGrid();
        $grid->setDefaultPerPage(50);

        $qb = $this->em->getRepository(Supplier::class)->createQueryBuilder('s')->select('s.id, s.name, s.isPublished')
            ->leftJoin(SupplierTexts::class, 'st', 'WITH', 's.id = st.id')
            ->where('st.lang = :lang')->setParameter('lang', 'cs')->getQuery()->getResult();
        $grid->setDataSource($qb);

        // Columns
        $grid->addColumnText('id', 'eshopCatalog.defaultGrid.id');
        $grid->addColumnLink('name', 'eshopCatalog.defaultGrid.name', 'ManufacturersSuppliers:editSupplier');
        $grid->addColumnStatus('isPublished', 'eshopCatalog.defaultGrid.isPublished')->setAlign('center')
            ->addOption(1, 'eshopCatalog.defaultGrid.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
            ->addOption(0, 'eshopCatalog.defaultGrid.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
            ->onChange[] = [$this, 'gridPublishChange'];


        // Actions
        $grid->addAction('edit', '', 'ManufacturersSuppliers:editSupplier')->setIcon('edit')->setBsType('primary');
        $grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax');

        // Columns prototype

        return $grid;
    }

    /*******************************************************************************************************************
     * ==================  Handle
     */

    public function handleDelete($id)
    {
        $presenter = $this->getPresenter();
        if ($this-$this->supplierServices->removeSupplier($id))
            $presenter->flashMessage('eshopCatalog.defaultGrid.removed', Flashes::FLASH_SUCCESS);
        else
            $presenter->flashMessage('eshopCatalog.defaultGrid.removeFailed', Flashes::FLASH_DANGER);

        if ($presenter->isAjax()) {
            $this['grid']->reload();
            $presenter->redrawControl('flashes');
        } else
            $presenter->redirect('this');
    }

    /*******************************************************************************************************************
     * =================  Grid function
     */

    public function gridPublishChange($id, $newStatus)
    {
        $presenter = $this->getPresenter();

        if ($this->supplierServices->setPublish($id, $newStatus))
            $presenter->flashMessageSuccess('eshopCatalog.defaultGrid.publishChanged');
        else
            $presenter->flashMessageDanger('eshopCatalog.defaultGrid.publishChangeFailed');

        $qb = $this->em->getRepository(Supplier::class)->createQueryBuilder('s')->select('s.id, s.name, s.isPublished')
            ->leftJoin(SupplierTexts::class, 'st', 'WITH', 's.id = st.id')
            ->where('st.lang = :lang')->setParameter('lang', 'cs')->getQuery()->getResult();

        $this['grid']->setDataSource($qb);

        if ($presenter->isAjax()) {
            $this['grid']->redrawItem($id);
            $presenter->redrawControl('flashes');
        } else
            $presenter->redirect('this');
    }
}