<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Core\Model\Entities\ExtraField;
use EshopCatalog\Model\Config;
use EshopCatalog\Model\Entities\Product;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use Kdyby\Doctrine\EntityManager;

class OrderPseudoWarehouseSubscriber implements EventSubscriber
{
	/** @var EntityManager */
	protected $em;

	public function __construct(EntityManager $em)
	{
		$this->em = $em;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => ['orderOnSuccess', 100],
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		if (!Config::load('pseudoWarehouse'))
			return;

		$products = [];
		foreach ($event->order->getOrderItems() as $v) {
			$products[] = $v->getProductId();
		}

		$unlimited = [];
		foreach ($this->em->getRepository(Product::class)->createQueryBuilder('p')
			         ->select('p.id')
			         ->where('p.id IN (:ids)')->setParameter('ids', $products)
			         ->andWhere('p.unlimitedQuantity = 1')
			         ->getQuery()->getScalarResult() as $row)
			$unlimited[] = $row['id'];

		// Aktualizace počtu ks
		foreach ($event->order->getOrderItems() as $v) {
			if (in_array($v->getProductId(), $unlimited))
				continue;

			$this->em->createQueryBuilder()->update(Product::class, 'p')
				->set('p.quantity', 'p.quantity - :q')
				->where('p.id = :id')
				->setParameters([
					'q'  => $v->getQuantity(),
					'id' => $v->getProductId(),
				])->getQuery()->execute();
		}
	}
}
