<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\Form\BaseContainer;
use Nette\Localization\ITranslator;
use Nette\Utils\ArrayHash;
use EshopCatalog\AdminModule\Model\Categories;
use EshopCatalog\Model\Entities\Category;

/**
 * Class CategoryContainer
 * @package EshopCatalog\AdminModule\Components\Products
 */
class CategoryContainer
{
	/** @var ITranslator */
	protected $translator;

	/** @var Categories */
	protected $categoryServices;

	public function __construct(Categories $categories, ITranslator $translator)
	{
		$this->categoryServices = $categories;
		$this->translator       = $translator;
	}

	public function getContainer()
	{
		$container = new BaseContainer();

		$categories = [];
		$aktLevel   = 1;
		$id         = null;
		foreach ($this->categoryServices->em->getRepository(Category::class)->createQueryBuilder('c')
			         ->select('c.id, ct.name, c.lvl, c.lft, c.isPublished')
			         ->leftJoin('c.categoryTexts', 'ct', 'WITH', 'ct.lang = :lang')
			         ->setParameter('lang', $this->translator->getLocale())
			         ->andWhere('c.lvl > 0')
			         ->groupBy('c.id')
			         ->orderBy('c.root')->addOrderBy('c.lft')->getQuery()->getResult() as $c) {
			$name = (!$c['isPublished'] ? '[x ' . $c['name'] . ' x]' : $c['name']);
			$t    = '-';
			$p    = 0;
			if ($aktLevel < $c['lvl']) {
				$t = 'N';
				$p = 1;
			}
			if ($aktLevel > $c['lvl']) {
				$t = 'D';
				$p = $aktLevel - $c['lvl'];
			}
			$temp                 = $t . '_' . $p . '_' . $c['lvl'] . '_';
			$aktLevel             = $c['lvl'];
			$categories[$c['id']] = $name;

			if ($id != null) {
				$categories[$id] = $temp . $categories[$id];
			}
			$id = $c['id'];
		}
		$categories[$id] = 'D_' . $aktLevel . '_' . $categories[$id];

		$container->addRadioList('defaultCategory', 'eshopCatalog.productForm.defaultCategory', $categories);
		foreach ($categories as $key => $c) {
			$container->addCheckbox('category' . $key, $c);
		}


		return $container;
	}

	/**
	 * @param array|ArrayHash $values
	 *
	 * @return array
	 */
	public function getFormData($values): array
	{
		return (array) $values;
	}

	/**
	 * @param BaseContainer $container
	 * @param array         $values
	 */
	public function setDefaults(&$container, $values)
	{
		foreach ($container->getControls() as $c) {
			if (isset($values[$c->getName()])) {
				$c->setDefaultValue($values[$c->getName()]);
			}
		}
	}
}
