<?php declare(strict_types = 1);


namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\Form\BaseContainer;
use EshopCatalog\AdminModule\Model\ProductExports;
use Nette\Utils\ArrayHash;

/**
 * Class ExportContainer
 * @package EshopCatalog\AdminModule\Components\Products
 */
class ExportContainer
{
	/** @var Categories */
	protected $productExportServices;

	public function __construct(ProductExports $productExports)
	{
		$this->productExportServices = $productExports;
	}

	public function getContainer()
	{
		$container = new BaseContainer();

		$container->addCheckbox('isZbozi', 'eshopCatalog.exportContainer.exportZbozi');
		$container->addCheckbox('isHeureka', 'eshopCatalog.exportContainer.exportHeureka');
		$container->addCheckbox('isGoogle', 'eshopCatalog.exportContainer.exportGoogle');

		return $container;
	}

	/**
	 * @param array|ArrayHash $values
	 *
	 * @return array
	 */
	public function getFormData($values): array
	{
		return (array) $values;
	}

	/**
	 * @param BaseContainer $container
	 * @param array         $values
	 */
	public function setDefaults(&$container, $values)
	{
		foreach ($container->getControls() as $c) {
			if (isset($values[$c->getName()]))
				$c->setDefaultValue($values[$c->getName()]);
		}
	}
}
