<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class FilterGroup
 * @package EshopCatalog\FrontModule\Model\Dao
 */
class FilterGroup
{
	use MagicAccessors;

	/** @var int */
	public $id;

	/** @var string */
	public $type;

	/** @var string */
	public $name;

	/** @var FilterItem[] */
	public $items;

	/**
	 * @return FilterItem[]
	 */
	public function getItemsWithProducts()
	{
		$items = [];
		foreach ($this->items as $item) {
			if ($item->productsCount > 0)
				$items[] = $item;
		}

		return $items;
	}
}
