<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

/**
 * Class Config
 * @package EshopCatalog\Model
 */
class Config
{
	/** @var array */
	protected $config;

	/**
	 * Config constructor.
	 *
	 * @param $config
	 */
	public function __construct($config)
	{
		$this->config = $config;
	}

	/**
	 * @param string $key
	 * @param mixed  $default
	 *
	 * @return mixed|null
	 */
	public function get($key, $default = null)
	{
		return $this->config[$key] ?? $default;
	}
}
