<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Event;

use EshopCatalog\FrontModule\Model\Dao\Category;
use Navigations\Model\Entities\Navigation;
use Symfony\Component\EventDispatcher\Event;

class RouteInFindAliasEvent extends Event
{
	/** @var string */
	public $alias;

	/** @var array */
	public $urlParams;

	/** @var array */
	public $return;

	public function __construct(string $alias, array $urlParams, array &$return)
	{
		$this->alias     = $alias;
		$this->urlParams = $urlParams;
		$this->return    = &$return;
	}
}
