<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="eshop_catalog__product_tag", indexes={@ORM\Index(name="valid_idx", columns={"valid_from", "valid_to"})})
 * @ORM\Entity
 */
class ProductTag
{
	use MagicAccessors;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="ProductTags", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $product;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Tag")
	 * @ORM\JoinColumn(name="id_tag", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $tag;

	/**
	 * @var DateTime
	 * @ORM\Column(name="valid_from", type="datetime", nullable=true)
	 */
	public $validFrom;

	/**
	 * @var DateTime
	 * @ORM\Column(name="valid_to", type="datetime", nullable=true)
	 */
	public $validTo;

	public function __construct(Product $product, Tag $tag)
	{
		$this->product = $product;
		$this->tag     = $tag;
	}

	/**
	 * @return mixed
	 */
	public function getProduct()
	{
		return $this->product;
	}

	/**
	 * @return mixed
	 */
	public function getTag()
	{
		return $this->tag;
	}
}
