<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class Variant
 * @package EshopCatalog\Model\Entities
 *
 * @ORM\Table(name="eshop_catalog__variant")
 * @ORM\Entity
 * @ORM\EntityListeners({"VariantListener"})
 */
class Variant
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var int
	 * @ORM\Column(name="use_filter", type="smallint", length=1)
	 */
	public $useAsFilter;

	/**
	 * @var int
	 * @ORM\Column(name="type", type="smallint")
	 */
	public $type;

	/**
	 * @var VariantText[]
	 * @ORM\OneToMany(targetEntity="VariantText", mappedBy="variant", indexBy="lang", cascade={"all"})
	 */
	protected $texts;

	/**
	 * @var VariantValue[]
	 * @ORM\OneToMany(targetEntity="VariantValue", mappedBy="variant", indexBy="id", cascade={"all"})
	 */
	protected $values;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * Variant constructor.
	 */
	public function __construct()
	{
		$this->texts       = new ArrayCollection();
		$this->values      = new ArrayCollection();
		$this->isPublished = 0;
		$this->setPosition(-1);
	}

	/**
	 * @param string $lang
	 *
	 * @return $this
	 */
	public function addText(string $lang)
	{
		$this->texts->set($lang, new VariantText($this, $lang));

		return $this;
	}

	/**
	 * @param VariantText $variantTexts
	 *
	 * @return $this
	 */
	public function setText(VariantText $variantTexts)
	{
		$this->texts->set($variantTexts->getLang(), $variantTexts);

		return $this;
	}

	/**
	 * @param string $lang
	 *
	 * @return VariantText
	 */
	public function getText(string $lang) { return $this->texts->get($lang); }

	/**
	 * @return ArrayCollection|VariantText[]
	 */
	public function getTexts() { return $this->texts; }

	/******
	 * === Position
	 */

	/**
	 * @param int $position
	 *
	 * @return $this
	 */
	public function setPosition($position)
	{
		$this->position = $position;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getPosition() { return $this->position; }
}

