import autoComplete from "core/../node_modules/@tarekraafat/autocomplete.js/src/models/autoComplete"

let exportsLoaded = [];
let exportsLastXhr = [];
const exportUrls = {
	heureka: 'https://api-evidence.pshk.cz/v1/cms/heureka-export-categories',
	zbozi: 'https://api-evidence.pshk.cz/v1/cms/zbozi-export-categories',
	google: 'https://api-evidence.pshk.cz/v1/cms/google-export-categories',
};

const initInputs = () => {
	document.querySelectorAll('[data-grader-type]:not(.init)').forEach(input => {
		input.classList.add('init');
		let type = input.dataset.graderType;
		let inputId = input.id;

		if (!exportUrls[type])
			return true;

		input.parentElement.style.position = 'relative';

		let dataLoader = new autoComplete({
			data: {
				src  : async () => {
					console.log('src');
					let url = exportUrls[type];

					if (exportsLoaded[url])
						return exportsLoaded[url];

					if (typeof exportsLastXhr[url] !== 'undefined' && exportsLastXhr[url].hasOwnProperty('abort'))
						exportsLastXhr[url].abort();

					let source = await fetch(url, {
						method: 'GET',
					});

					let result = await source.json();

					if (result.data !== undefined) {
						result = result.data;
					}

					exportsLoaded[url] = [];
					for (let a in result) {
						let row = result[a];

						if (typeof row === 'string' || row instanceof String) {
							row = {
								id  : a,
								name: row,
							};
						} else {
							if (row.id === undefined) {
								row.id = a;
							}
						}

						exportsLoaded[url][a] = row;
					}

					return exportsLoaded[url];
				},
				key: ['name'],
				cache: true,
			},
			cache: false,
			selector: '#' + inputId,
			maxResults: 20,
			threshold: 2,
			resultsList: {
				render: true,
				destination: input,
				position: "afterend",
				element: "ul"
			},
			resultItem: {
				content: (data, source) => {
					source.innerHTML = data.index + ' | ' + data.value.name;
				},
				element: "li"
			},
			onSelection: feedback => {
				input.value = feedback.selection.value.name;
			}
		});
	});
};

initInputs();

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	initInputs();
});

global.naja.addEventListener('complete', e => {
	initInputs();
});
