<?php declare(strict_types = 1);

namespace EshopCatalog\Console\Cache;

use Contributte\Application\LinkGenerator;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopCatalog\FrontModule\Model\Categories;
use EshopCatalog\FrontModule\Model\FeatureProducts;
use EshopCatalog\FrontModule\Model\Products;
use EshopCatalog\FrontModule\Model\ProductVariants;
use EshopCatalog\Model\Entities\ProductVariantSupplier;
use Kdyby;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

/**
 * Class Generate
 * @package EshopCatalog\Console\Seo
 */
class Generate extends AbstractCommand
{
	/** @var Categories @inject */
	public $categoriesService;

	/** @var Products @inject */
	public $productsService;

	/** @var ProductVariants @inject */
	public $productVariantsService;

	/** @var FeatureProducts @inject */
	public $productFeaturesService;

	/** @var LinkGenerator @inject */
	public $linkGenerator;

	protected function configure()
	{
		$this->setName('eshop-catalog:cache:generate')->setDescription('Generate eshop catalog cache');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('GENERATE ESHOP-CATALOG CACHE');

		try {
			set_time_limit(600);
			Debugger::dispatch();

			$this->categoriesService->linkGenerator = $this->linkGenerator;
			$this->productsService->linkGenerator   = $this->linkGenerator;

			// Kategorie
			$output->writeLn('<info>- Hierarchy</info>');
			$this->categoriesService->getHierarchy();
			$this->categoriesService->em->clear();

			// Produkty
			$products = [];
			foreach ($this->categoriesService->getEr()->createQueryBuilder('c')->select('c.id')->where('c.isPublished = 1')->getQuery()->getScalarResult() as $c) {
				$output->writeLn('<info>- Products in category: ' . $c['id'] . '</info>');
				$products = array_merge($products, $this->productsService->getProductsIdInCategory($c['id']));
				$this->productsService->getProductsInCategoryCount($c['id']);
				$this->productsService->em->clear();
			}

			$output->writeLn('<info>Products</info>');
			foreach ($products as $product) {
				$this->productsService->get($product);
				$this->productVariantsService->getProductVariantsForProduct($product);
				$this->productFeaturesService->getFeaturesForProduct([$product])[$product->getId()];

				$this->productsService->em->clear();
			}

			$output->writeLn('<info>[OK]</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}
	}
}
