<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

/**
 * Class Config
 * @package EshopCatalog\Model
 */
class Config extends \Core\Model\Config
{
	public static function setParams($params)
	{
		parent::setParams($params);
		self::updateParams();
	}

	protected static function updateParams()
	{
		$params = self::$params[get_called_class()];
		$result = $params['config'];

		unset($params['config']);
		foreach ($params as $k => $v)
			$result[$k] = $v;

		self::$params[get_called_class()] = $result;
	}
}
