<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use EshopCatalog\Model\Entities\Variant;

/**
 * Class Variants
 * @package EshopCatalog\AdminModule\Model
 *
 * @method Variant|null|object = getReference($id)
 * @method Variant[]|null getAll()
 * @method Variant|null get($id)
 */
class Variants extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Variant::class;

	/**
	 * @param int $id
	 * @param int $state
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setUseAsFilter($id, $state)
	{
		if ($item = $this->get($id)) {
			$item->useAsFilter = $state;
			$this->em->persist($item)->flush();

			return true;
		}

		return false;
	}

	/**
	 * @param int $id
	 * @param int $position
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setPosition($id, $position)
	{
		if ($item = $this->getReference($id)) {
			$item->setPosition((int) $position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}
}

