<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190201161858 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE eshop_catalog__attribute (id INT AUTO_INCREMENT NOT NULL, position SMALLINT NOT NULL, use_filter SMALLINT NOT NULL, type SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__attribute_texts (lang VARCHAR(2) NOT NULL, id INT NOT NULL, name VARCHAR(255) NOT NULL, INDEX IDX_6A216449BF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__attribute_value (id INT AUTO_INCREMENT NOT NULL, attribute_id INT DEFAULT NULL, INDEX IDX_69632FC2B6E62EFA (attribute_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__attribute_value_texts (lang VARCHAR(2) NOT NULL, id INT NOT NULL, name VARCHAR(255) NOT NULL, INDEX IDX_E529500BBF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__category (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, tree_root INT DEFAULT NULL, is_published SMALLINT DEFAULT 0 NOT NULL, lft INT NOT NULL, lvl INT NOT NULL, rgt INT NOT NULL, seo LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_287FA34A727ACA70 (parent_id), INDEX IDX_287FA34AA977936C (tree_root), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__category_product (id_product INT NOT NULL, id_category INT NOT NULL, INDEX IDX_62D929D7DD7ADDD (id_product), INDEX IDX_62D929D75697F554 (id_category), PRIMARY KEY(id_product, id_category)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__category_texts (lang VARCHAR(2) NOT NULL, id INT NOT NULL, name VARCHAR(255) NOT NULL, alias VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, INDEX IDX_84B94FDBF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__feature (id INT AUTO_INCREMENT NOT NULL, position SMALLINT NOT NULL, is_published SMALLINT NOT NULL, use_filter SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__feature_product (id_product INT NOT NULL, id_feature INT NOT NULL, id_feature_value INT DEFAULT NULL, INDEX IDX_75710BE4DD7ADDD (id_product), INDEX IDX_75710BE4C14ADC16 (id_feature), INDEX IDX_75710BE46A018358 (id_feature_value), PRIMARY KEY(id_product, id_feature)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__feature_texts (lang VARCHAR(2) NOT NULL, id INT NOT NULL, name VARCHAR(255) NOT NULL, INDEX IDX_4EB8642EBF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__feature_value (id INT AUTO_INCREMENT NOT NULL, feature_id INT DEFAULT NULL, INDEX IDX_4DFA2FA560E4B879 (feature_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__feature_value_texts (lang VARCHAR(2) NOT NULL, id INT NOT NULL, name VARCHAR(255) NOT NULL, INDEX IDX_FD42FFBBF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__manufacturer (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, logo VARCHAR(255) DEFAULT NULL, is_published SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__manufacturer_texts (lang VARCHAR(2) NOT NULL, id INT NOT NULL, description LONGTEXT DEFAULT NULL, INDEX IDX_42042905BF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__product (id INT AUTO_INCREMENT NOT NULL, id_manufacturer INT DEFAULT NULL, id_category_default INT DEFAULT NULL, id_vat_rate INT DEFAULT NULL, gallery_id INT DEFAULT NULL, is_published SMALLINT NOT NULL, in_stock SMALLINT NOT NULL, quantity INT NOT NULL, price NUMERIC(10, 2) DEFAULT NULL, retail_price NUMERIC(10, 2) DEFAULT NULL, ean VARCHAR(20) DEFAULT NULL, code1 VARCHAR(60) DEFAULT NULL, code2 VARCHAR(60) DEFAULT NULL, seo LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_54FD0ED01ECB93AE (id_manufacturer), INDEX IDX_54FD0ED0C70C1570 (id_category_default), INDEX IDX_54FD0ED0A65F1B52 (id_vat_rate), UNIQUE INDEX UNIQ_54FD0ED04E7AF8F (gallery_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__product_attribute (id INT AUTO_INCREMENT NOT NULL, id_product INT DEFAULT NULL, is_default SMALLINT NOT NULL, quantity INT NOT NULL, ean VARCHAR(20) DEFAULT NULL, code1 VARCHAR(60) DEFAULT NULL, code2 VARCHAR(60) DEFAULT NULL, unit_price_impact NUMERIC(10, 2) DEFAULT NULL, INDEX IDX_93C1D602DD7ADDD (id_product), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__product_attribute_combination (id_product_attribute INT NOT NULL, id_attribute_value INT NOT NULL, INDEX IDX_EF000F5265ED3161 (id_product_attribute), INDEX IDX_EF000F521711780A (id_attribute_value), PRIMARY KEY(id_product_attribute, id_attribute_value)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__product_supplier (id_product INT NOT NULL, id_supplier INT NOT NULL, quantity INT NOT NULL, code VARCHAR(255) NOT NULL, INDEX IDX_26D16BEDDD7ADDD (id_product), INDEX IDX_26D16BEDCBF180EB (id_supplier), PRIMARY KEY(id_product, id_supplier)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__product_texts (lang VARCHAR(2) NOT NULL, id INT NOT NULL, name VARCHAR(255) NOT NULL, short_description VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, INDEX IDX_26BA157BBF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__supplier (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, logo VARCHAR(255) DEFAULT NULL, is_published SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__supplier_texts (lang VARCHAR(2) NOT NULL, id INT NOT NULL, description LONGTEXT DEFAULT NULL, INDEX IDX_3963D99EBF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__vat_rate (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, rate SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_texts ADD CONSTRAINT FK_6A216449BF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__attribute (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_value ADD CONSTRAINT FK_69632FC2B6E62EFA FOREIGN KEY (attribute_id) REFERENCES eshop_catalog__attribute (id)');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_value_texts ADD CONSTRAINT FK_E529500BBF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__attribute_value (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__category ADD CONSTRAINT FK_287FA34A727ACA70 FOREIGN KEY (parent_id) REFERENCES eshop_catalog__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__category ADD CONSTRAINT FK_287FA34AA977936C FOREIGN KEY (tree_root) REFERENCES eshop_catalog__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__category_product ADD CONSTRAINT FK_62D929D7DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__category_product ADD CONSTRAINT FK_62D929D75697F554 FOREIGN KEY (id_category) REFERENCES eshop_catalog__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__category_texts ADD CONSTRAINT FK_84B94FDBF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product ADD CONSTRAINT FK_75710BE4DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id)');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product ADD CONSTRAINT FK_75710BE4C14ADC16 FOREIGN KEY (id_feature) REFERENCES eshop_catalog__feature (id)');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product ADD CONSTRAINT FK_75710BE46A018358 FOREIGN KEY (id_feature_value) REFERENCES eshop_catalog__feature_value (id)');
		$this->addSql('ALTER TABLE eshop_catalog__feature_texts ADD CONSTRAINT FK_4EB8642EBF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__feature (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value ADD CONSTRAINT FK_4DFA2FA560E4B879 FOREIGN KEY (feature_id) REFERENCES eshop_catalog__feature (id)');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value_texts ADD CONSTRAINT FK_FD42FFBBF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__feature_value (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__manufacturer_texts ADD CONSTRAINT FK_42042905BF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__manufacturer (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__product ADD CONSTRAINT FK_54FD0ED01ECB93AE FOREIGN KEY (id_manufacturer) REFERENCES eshop_catalog__manufacturer (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE eshop_catalog__product ADD CONSTRAINT FK_54FD0ED0C70C1570 FOREIGN KEY (id_category_default) REFERENCES eshop_catalog__category (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE eshop_catalog__product ADD CONSTRAINT FK_54FD0ED0A65F1B52 FOREIGN KEY (id_vat_rate) REFERENCES eshop_catalog__vat_rate (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE eshop_catalog__product ADD CONSTRAINT FK_54FD0ED04E7AF8F FOREIGN KEY (gallery_id) REFERENCES gallery__album (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute ADD CONSTRAINT FK_93C1D602DD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id)');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute_combination ADD CONSTRAINT FK_EF000F5265ED3161 FOREIGN KEY (id_product_attribute) REFERENCES eshop_catalog__product_attribute (id)');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute_combination ADD CONSTRAINT FK_EF000F521711780A FOREIGN KEY (id_attribute_value) REFERENCES eshop_catalog__attribute_value (id)');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier ADD CONSTRAINT FK_26D16BEDDD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id)');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier ADD CONSTRAINT FK_26D16BEDCBF180EB FOREIGN KEY (id_supplier) REFERENCES eshop_catalog__supplier (id)');
		$this->addSql('ALTER TABLE eshop_catalog__product_texts ADD CONSTRAINT FK_26BA157BBF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__supplier_texts ADD CONSTRAINT FK_3963D99EBF396750 FOREIGN KEY (id) REFERENCES eshop_catalog__supplier (id) ON DELETE CASCADE');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE eshop_catalog__attribute_texts DROP FOREIGN KEY FK_6A216449BF396750');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_value DROP FOREIGN KEY FK_69632FC2B6E62EFA');
		$this->addSql('ALTER TABLE eshop_catalog__attribute_value_texts DROP FOREIGN KEY FK_E529500BBF396750');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute_combination DROP FOREIGN KEY FK_EF000F521711780A');
		$this->addSql('ALTER TABLE eshop_catalog__category DROP FOREIGN KEY FK_287FA34A727ACA70');
		$this->addSql('ALTER TABLE eshop_catalog__category DROP FOREIGN KEY FK_287FA34AA977936C');
		$this->addSql('ALTER TABLE eshop_catalog__category_product DROP FOREIGN KEY FK_62D929D75697F554');
		$this->addSql('ALTER TABLE eshop_catalog__category_texts DROP FOREIGN KEY FK_84B94FDBF396750');
		$this->addSql('ALTER TABLE eshop_catalog__product DROP FOREIGN KEY FK_54FD0ED0C70C1570');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product DROP FOREIGN KEY FK_75710BE4C14ADC16');
		$this->addSql('ALTER TABLE eshop_catalog__feature_texts DROP FOREIGN KEY FK_4EB8642EBF396750');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value DROP FOREIGN KEY FK_4DFA2FA560E4B879');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product DROP FOREIGN KEY FK_75710BE46A018358');
		$this->addSql('ALTER TABLE eshop_catalog__feature_value_texts DROP FOREIGN KEY FK_FD42FFBBF396750');
		$this->addSql('ALTER TABLE eshop_catalog__manufacturer_texts DROP FOREIGN KEY FK_42042905BF396750');
		$this->addSql('ALTER TABLE eshop_catalog__product DROP FOREIGN KEY FK_54FD0ED01ECB93AE');
		$this->addSql('ALTER TABLE eshop_catalog__category_product DROP FOREIGN KEY FK_62D929D7DD7ADDD');
		$this->addSql('ALTER TABLE eshop_catalog__feature_product DROP FOREIGN KEY FK_75710BE4DD7ADDD');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute DROP FOREIGN KEY FK_93C1D602DD7ADDD');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier DROP FOREIGN KEY FK_26D16BEDDD7ADDD');
		$this->addSql('ALTER TABLE eshop_catalog__product_texts DROP FOREIGN KEY FK_26BA157BBF396750');
		$this->addSql('ALTER TABLE eshop_catalog__product_attribute_combination DROP FOREIGN KEY FK_EF000F5265ED3161');
		$this->addSql('ALTER TABLE eshop_catalog__product_supplier DROP FOREIGN KEY FK_26D16BEDCBF180EB');
		$this->addSql('ALTER TABLE eshop_catalog__supplier_texts DROP FOREIGN KEY FK_3963D99EBF396750');
		$this->addSql('ALTER TABLE eshop_catalog__product DROP FOREIGN KEY FK_54FD0ED0A65F1B52');
		$this->addSql('DROP TABLE eshop_catalog__attribute');
		$this->addSql('DROP TABLE eshop_catalog__attribute_texts');
		$this->addSql('DROP TABLE eshop_catalog__attribute_value');
		$this->addSql('DROP TABLE eshop_catalog__attribute_value_texts');
		$this->addSql('DROP TABLE eshop_catalog__category');
		$this->addSql('DROP TABLE eshop_catalog__category_product');
		$this->addSql('DROP TABLE eshop_catalog__category_texts');
		$this->addSql('DROP TABLE eshop_catalog__feature');
		$this->addSql('DROP TABLE eshop_catalog__feature_product');
		$this->addSql('DROP TABLE eshop_catalog__feature_texts');
		$this->addSql('DROP TABLE eshop_catalog__feature_value');
		$this->addSql('DROP TABLE eshop_catalog__feature_value_texts');
		$this->addSql('DROP TABLE eshop_catalog__manufacturer');
		$this->addSql('DROP TABLE eshop_catalog__manufacturer_texts');
		$this->addSql('DROP TABLE eshop_catalog__product');
		$this->addSql('DROP TABLE eshop_catalog__product_attribute');
		$this->addSql('DROP TABLE eshop_catalog__product_attribute_combination');
		$this->addSql('DROP TABLE eshop_catalog__product_supplier');
		$this->addSql('DROP TABLE eshop_catalog__product_texts');
		$this->addSql('DROP TABLE eshop_catalog__supplier');
		$this->addSql('DROP TABLE eshop_catalog__supplier_texts');
		$this->addSql('DROP TABLE eshop_catalog__vat_rate');
	}
}
