<?php declare(strict_types = 1);


namespace EshopCatalog\AdminModule\Components\Products;


use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\ProductExports;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\Model\Entities\Product;
use EshopCatalog\Model\Entities\ProductExport;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;

class ProductsExportForm extends BaseControl
{
	/** @var array */
	public $products;

	/** @var string */
	private $ids;

	/** @var Products */
	protected $productServices;

	/** @var ProductExports */
	protected $productExportServices;

	/** @var ExportContainer */
	protected $productExportCotainer;

	public function __construct(Products $products, ProductExports $productExports, ExportContainer $exportContainer)
	{
		$this->productServices       = $products;
		$this->productExportServices = $productExports;
		$this->productExportCotainer = $exportContainer;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addHidden('produtcIds', $this->ids);
		$form->addComponent($this->productExportCotainer->getContainer(), 'export');

		$form->addSaveCancelControl('saveControl');
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$exports = $this->productExportCotainer->getFormData($values->export);
			foreach ($this->products as $product) {
				$productExport = $product->getProductExport();
				if (!isset($productExport))
					$productExport = new ProductExport();
				$productExport->isZbozi   = $exports['isZbozi'];
				$productExport->isHeureka = $exports['isHeureka'];
				$productExport->isGoogle  = $exports['isGoogle'];
				$product->setProductExport($productExport);
				$this->em->persist($product);
			}

			$this->em->flush();

			$form->addCustomData('productIds', $values->produtcIds);
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.productForm.productSaved', Flashes::FLASH_SUCCESS);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	/*******************************************************************************************************************
	 * ========================  GET / SET
	 */

	public function setProducts($ids)
	{
		$this->ids  = $ids;
		$productIds = explode('-', $ids);

		$export       = [];
		$isSameExport = true;

		foreach ($productIds as $id) {
			$this->products[$id] = $this->em->getRepository(Product::class)->find($id);
			$productExport       = $this->products[$id]->getProductExport();
			if (!isset($productExport))
				$isSameExport = false;
			else {
				if (isset($export['isZbozi'])) {
					if ($export['isZbozi'] != $productExport->isZbozi)
						$isSameExport = false;
				} else
					$export['isZbozi'] = $productExport->isZbozi;
				if (isset($export['isHeureka'])) {
					if ($export['isHeureka'] != $productExport->isHeureka)
						$isSameExport = false;
				} else
					$export['isHeureka'] = $productExport->isHeureka;
				if (isset($export['isGoogle'])) {
					if ($export['isGoogle'] != $productExport->isGoogle)
						$isSameExport = false;
				} else
					$export['isGoogle'] = $productExport->isGoogle;
			}
		}

		bdump($isSameExport);
		bdump($export);

		if (!$this->products)
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);

		if ($isSameExport)
			$this->productExportCotainer->setDefaults($this['form']['export'], $export);
	}
}
