<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\VatRates;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Nette\Utils\Html;
use EshopCatalog\Model\Entities\VatRate;
use EshopCatalog\AdminModule\Model\VatRates;

class VatRatesGrid extends BaseControl
{
	/** @var \EshopCatalog\AdminModule\Model\VatRates */
	protected $vatRateServices;
	
	public function __construct(VatRates $vatRate)
	{
		$this->vatRateServices = $vatRate;
	}

	public function render()
	{
		$this->template->setFile(__DIR__ . '/VatRatesGrid.latte');
		$this->template->render();
	}
	
	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		$grid->setDefaultPerPage(50);

		$qb = $this->em->getRepository(VatRate::class)->createQueryBuilder('vr')->select('vr.id, vr.name, vr.rate')
				->getQuery()->getResult();
		$grid->setDataSource($qb);

		bdump($qb);

		// Columns
		$grid->addColumnText('id', 'eshopCatalog.defaultGrid.id');
		$grid->addColumnLink('name', 'eshopCatalog.defaultGrid.name', 'Products:editVatRate');
		$grid->addColumnNumber('rate', 'eshopCatalog.defaultGrid.value');
		

		// Actions
		$grid->addAction('edit', '', 'Products:editVatRate')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax');

		// Columns prototype

		return $grid;
	}
	
	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->vatRateServices->removeVatRate($id))
			$presenter->flashMessage('eshopCatalog.defaultGrid.removed', Flashes::FLASH_SUCCESS);
		else
			$presenter->flashMessage('eshopCatalog.defaultGrid.removeFailed', Flashes::FLASH_DANGER);

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}
