<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\GroupCustomers;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__product_price_level")
 */
class ProductPriceLevel
{
	use MagicAccessors;

	/**
	 * @var Product
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="priceLevels", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $productId;

	/**
	 * @var GroupCustomers
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\GroupCustomers")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $groupId;

	/**
	 * @var double
	 * @ORM\Column(name="price", type="decimal", precision=10, scale=2)
	 */
	public $price;

	public function __construct(Product $productId, GroupCustomers $groupId)
	{
		$this->productId = $productId;
		$this->groupId   = $groupId;
	}

}
