<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model\Helpers;

use EshopCatalog\AdminModule\Model\ProductPriceLevels;
use EshopCatalog\Model\Config;
use EshopOrders\AdminModule\Model\GroupsCustomers;
use EshopOrders\Model\Entities\GroupCustomers;

class ProductFormHelper
{
	/** @var GroupsCustomers @inject */
	public $groupsCustomersService;

	/** @var ProductPriceLevels @inject */
	public $productPriceLevelsService;

	/** @var Config @inject */
	public $config;

	/** @var GroupCustomers[] */
	protected $groupCustomers;

	/**
	 * @return GroupCustomers[]
	 */
	public function getGroupCustomers()
	{
		if ($this->groupCustomers === null)
			$this->groupCustomers = $this->groupsCustomersService->getEr()->createQueryBuilder('g', 'g.id')->getQuery()->getResult();

		return $this->groupCustomers;
	}
}
