<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Export;

use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\Provider\IXmlExportService;
use Nette\Utils\FileSystem;

abstract class XmlService implements IXmlExportService
{
	/** @var string */
	protected $name;

	/** @var string */
	public $baseUrl;

	protected $fileHandle;

	public function getFilePathTemp(): string
	{
		return TMP_DIR . "/exportproducts/{$this->name}.xml";
	}

	public function getFilePath(): string
	{
		return WWW_DIR . "/exportproducts/{$this->name}.xml";
	}

	public function startExport(): void
	{
		FileSystem::createDir(dirname($this->getFilePathTemp()));;
		$this->fileHandle = fopen($this->getFilePathTemp(), 'w');
	}

	public function writeToFile(string $data): void
	{
		if ($this->fileHandle)
			fwrite($this->fileHandle, $data);
	}

	public function setBaseUrl(string $baseUrl) { $this->baseUrl = $baseUrl; }

	public function getName(): string { return $this->name; }

	public function prepareExportData(Product $product): array
	{
		$ef       = $product->getExtraFields();
		$export   = $ef['export'][$this->name];
		$category = [];

		foreach ($ef['category']['exports'] as $exports) {
			$vals = $exports[$this->name];

			if (!isset($category['status']) || $category['status'] == 2)
				$category['status'] = $vals['status'];
			if (!$category['categoryText'])
				$category['categoryText'] = $vals['categoryText'];
		}

		if (empty($category))
			$category = $ef['category'];
		if ($category['status'] == 2)
			$category['status'] = $ef['category']['status'];

		if (!$export)
			$export = ['status' => 2];

		if (empty($export) || $export['status'] == 2)
			$export['status'] = $category['status'];

		if (!$export['categoryText'])
			$export['categoryText'] = $category['categoryText'];

		if (!$export['productName'])
			$export['productName'] = $product->getName();

		if (!$export['product'])
			$export['product'] = $export['productName'];

		return $export;
	}

	public function endExport()
	{
		fclose($this->fileHandle);
		FileSystem::rename($this->getFilePathTemp(), $this->getFilePath(), true);
	}
}
