<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\Products;
use EshopCatalog\Model\Navigation\Home;
use Kdyby\Events\Subscriber;
use Nette\Localization\ITranslator;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;
use Slides\FrontModule\Model\Slides;
use Slides\Model\Entities\Slide;

class TagListener implements Subscriber
{
	use SmartObject;

	/** @var Cache */
	protected $cache;

	/** @var ITranslator */
	protected $translator;

	public function __construct(IStorage $cacheStorage, ITranslator $translator)
	{
		$this->cache      = new Cache($cacheStorage, Products::CACHE_NAMESPACE);
		$this->translator = $translator;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param Product            $product
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($product, $args)
	{
		//		$this->cache->clean([
		//			Cache::TAGS => [
		//				'product/' . $product->getId(),
		//			],
		//		]);
		//
		//		$this->navigationCache->clean([
		//			Cache::TAGS => [
		//				Home::CACHE_PRODUCT . '/' . $product->getId(),
		//			],
		//		]);
	}
}
