<?php declare(strict_types=1);

namespace EshopCatalog\AdminModule\Components\VatRates;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use EshopCatalog\Model\Entities\VatRate;
use EshopCatalog\AdminModule\Model\VatRates;

class VatRateForm extends BaseControl{
	/** @var VatRate */
	public $vatRate;
	
	/** @var \EshopCatalog\AdminModule\Model\VatRates */
	protected $vatRateServices;
	
	public function __construct(VatRates $vatRates)
	{
		$this->vatRateServices = $vatRates;
	}
	
	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}
	
	protected function createComponentForm()
	{
		$form = $this->createForm();
		
		$form->addText('name', 'eshopCatalog.vatRateForm.name')->setRequired()->setMaxLength(255);
		$form->addInteger('rate', 'eshopCatalog.vatRateForm.rate')->setRequired();
		
		$form->addSaveCancelControl('saveControl');
		
		//editace 
		if ($this->vatRate) {
			$form->setDefaults([
				'name'		=> $this->vatRate->name,
				'rate'		=> $this->vatRate->rate,     
			]);
		}
		
		$form->onSuccess[] = [$this, 'formSuccess'];
		
		return $form;
	}
	
	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$vatRate = $this->vatRate ? : new VatRate();
			
			$vatRate->name = $values->name;
			$vatRate->rate = $values->rate;
			
			$this->em->persist($vatRate);
			$this->em->flush();
			$form->addCustomData('vatRateId', $vatRate->getId());
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.vatRateForm.vatRateSaved', Flashes::FLASH_SUCCESS);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}
	
	public function setVatRate($id)
	{
		$this->vatRate = $this->em->getRepository(VatRate::class)->find($id);

		if (!$this->vatRate)
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
