<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class ProductVariant
 * @package EshopCatalog\FrontModule\Model\Dao
 *
 * Jedná se o varianty k produktu
 */
class ProductVariant
{
	use MagicAccessors;

	/** @var int */
	private $id;

	/** @var int */
	public $isDefault;

	/** @var int */
	public $product;

	/** @var array */
	public $variants;

	/** @var int */
	public $quantity;

	/** @var string */
	public $ean;

	/** @var float */
	public $unitPriceImpact;

	public $key;

	public $value;

	public function __construct($id)
	{
		$this->id = $id;
	}

	/**
	 * @return int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * @return int
	 */
	public function getisDefault()
	{
		return $this->isDefault;
	}

	/**
	 * @param int $isDefault
	 */
	public function setIsDefault($isDefault)
	{
		$this->isDefault = $isDefault;
	}

	/**
	 * @return int
	 */
	public function getProduct()
	{
		return $this->product;
	}

	/**
	 * @param int $product
	 */
	public function setProduct($product)
	{
		$this->product = $product;
	}

	/**
	 * @return array
	 */
	public function getVariants()
	{
		return $this->variants;
	}

	/**
	 * @param array $variants
	 */
	public function setVariants($variants)
	{
		$this->variants = $variants;
	}

	/**
	 * @return int
	 */
	public function getQuantity()
	{
		return $this->quantity;
	}

	/**
	 * @param int $quantity
	 */
	public function setQuantity($quantity)
	{
		$this->quantity = $quantity;
	}

	/**
	 * @return string
	 */
	public function getEan()
	{
		return $this->ean;
	}

	/**
	 * @param string $ean
	 */
	public function setEan($ean)
	{
		$this->ean = $ean;
	}

	/**
	 * @return float
	 */
	public function getUnitPriceImpact()
	{
		return $this->unitPriceImpact;
	}

	/**
	 * @param float $unitPriceImpact
	 */
	public function setUnitPriceImpact($unitPriceImpact)
	{
		$this->unitPriceImpact = $unitPriceImpact;
	}

}
