<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class VariantsList
 * @package EshopCatalog\FrontModule\Model\Dao
 */
class VariantsList
{
	use MagicAccessors;

	/** @var int */
	private $id;

	/** @var string */
	public $name;

	/** @var ProductVariant[] */
	public $variants;

	/**
	 * VariantsList constructor.
	 *
	 * @param int $id
	 */
	public function __construct($id)
	{
		$this->id = $id;
	}

	/**
	 * @return int
	 */
	public function getId() { return $this->id; }
}
