<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\Lang\DefaultLang;
use Core\Model\UI\Form\BaseContainer;
use Nette\Utils\ArrayHash;
use EshopCatalog\AdminModule\Model\Tags;
use EshopCatalog\Model\Entities\Tag;

class TagsContainer
{
	/** @var DefaultLang */
	protected $defaultLang;

	/** @var Categories */
	protected $tagServices;

	public function __construct(Tags $tags, DefaultLang $defaultLang)
	{
		$this->tagServices = $tags;
		$this->defaultLang = $defaultLang;
	}

	public function getContainer()
	{
		$container = new BaseContainer();

		$tags = $this->tagServices->getEr()->createQueryBuilder('t')
			->select('t.id, t.type, tt.name')
			->leftJoin('t.texts', 'tt', 'WITH', 'tt.lang = :lang')
			->setParameter('lang', $this->defaultLang->locale)
			->getQuery()->getResult();

		foreach ($tags as $key => $t) {
			$container2 = new BaseContainer();
			$container2->addBool('active', $t['name']);
			$container2->addDatePicker('dateFrom', 'eshopCatalog.tagContainer.dateFrom')->setDescription('eshopCatalog.tagContainer.dateDesc');
			$container2->addDatePicker('dateTo', 'eshopCatalog.tagContainer.dateTo')->setDescription('eshopCatalog.tagContainer.dateDesc');
			$container2->addHidden('id', (string) $t['id']);

			$container->addComponent($container2, $t['type']);
		}

		$container->addCustomData('template', __DIR__ . '/TagsContainer.latte');

		return $container;
	}

	/**
	 * @param array|ArrayHash $values
	 *
	 * @return array
	 */
	public function getFormData($values): array
	{
		return (array) $values;
	}

	/**
	 * @param BaseContainer $container
	 * @param array         $values
	 */
	public function setDefaults(&$container, $values)
	{
		$container->setDefaults($values);
	}
}
