<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components;

use Core\AdminModule\Components\DataForm;
use Core\AdminModule\Model\Sites;

class SettingsForm extends DataForm
{
	/** @var Sites @inject */
	public ?Sites $sitesService = null;

	public function getDataForInputs(): array
	{
		$data = parent::getDataForInputs();

		foreach ($this->sitesService->getOptionsForSelect() as $site) {
			$data[] = [
				'name'  => $site . 'TermsAndConditionsNavId',
				'title' => [
					0 => 'eshopCatalog.settings.termsAndConditionsNavId',
					null,
					['name' => $site],
				],
				'type'  => 'text',
			];
			$data[] = [
				'name'  => $site . 'GdprNavId',
				'title' => [
					0 => 'eshopCatalog.settings.gdprNavId',
					null,
					['name' => $site],
				],
				'type'  => 'text',
			];
		}

		return $data;
	}

}
